

FFreqPD <- function(dataf){

  dataf <- dataf[order(dataf$Protein),]
  
matches <-list()
matches2 <-list()
N_Count=c()
for (prot in unique(dataf$Protein)) {
  
  
  DataProtein <- dataf %>% filter(Protein==prot)
  df <-NULL
  matches <-NULL
  sumdata <-NULL
  matches2 <-NULL
  DataProteinPosition <- cbind.data.frame(DataProtein$Unique_scan, DataProtein$Sequence, DataProtein$Protein, DataProtein$PRO_Position)
  colnames(DataProteinPosition) <- c("Spectrum", "Peptide", "Protein", "PRO_Position")
  DataProteinLocation <- cbind.data.frame(DataProtein$Unique_scan, DataProtein$PRO_Start, DataProtein$PRO_End)
  colnames(DataProteinLocation) <- c("Spectrum", "PRO_Start", "PRO_End")
  
  DataProteinLocationND <- DataProteinLocation[!duplicated(DataProteinLocation$Spectrum),]
  
  for (i in 1:length(DataProteinPosition$Spectrum)) {
    value <-NULL
   
    for (j in 1:length(DataProteinLocationND$Spectrum)) {
    
      value[j] <- dplyr::between(DataProteinPosition$PRO_Position[i],DataProteinLocationND$PRO_Start[j], DataProteinLocationND$PRO_End[j])
      
      
    }
    matches[[i]] <-value
    df <- do.call("rbind",matches) #combine all vectors into a matrix
    sumdata<-rowSums(df)
   
  }
  
 
  N_Count = c(N_Count, sumdata)
  
}
counts <- as.data.frame(N_Count)

finalSet <- cbind.data.frame(dataf,counts)

return(finalSet)

}